library pack1076;
use pack1076.pack1076.all;


entity LPMMUX8 is port (
   signal Data0_7:  in  vlbit;
   signal Data0_6:  in  vlbit;
   signal Data0_5:  in  vlbit;
   signal Data0_4:  in  vlbit;
   signal Data0_3:  in  vlbit;
   signal Data0_2:  in  vlbit;
   signal Data0_1:  in  vlbit;
   signal Data0_0:  in  vlbit;
   signal Data1_7:  in  vlbit;
   signal Data1_6:  in  vlbit;
   signal Data1_5:  in  vlbit;
   signal Data1_4:  in  vlbit;
   signal Data1_3:  in  vlbit;
   signal Data1_2:  in  vlbit;
   signal Data1_1:  in  vlbit;
   signal Data1_0:  in  vlbit;
   signal Sel0: in vlbit;
   signal Result: out vlbit_vector (7 downto 0));
end LPMMUX8;


architecture lpm of LPMMUX8 is
   signal x0l0, x1l0: vlbit_vector (7 downto 0);

   begin
      -- Assign output
      Result <= x0l0 after 0 ns when (Sel0 = '0')
         else x1l0 after 0 ns;

      -- Attach to inputs
      x0l0 <=
         Data0_7 &
         Data0_6 &
         Data0_5 &
         Data0_4 &
         Data0_3 &
         Data0_2 &
         Data0_1 &
         Data0_0;
      x1l0 <=
         Data1_7 &
         Data1_6 &
         Data1_5 &
         Data1_4 &
         Data1_3 &
         Data1_2 &
         Data1_1 &
         Data1_0;
end lpm;
